// DialogDrawDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "8949G1VC.h"
#include "DialogDrawDemoDlg.h"
#include "CtrlCardSingletion.h"
#include "DialogBasicMoveDlg.h"
#include "math.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDialogBasicMoveDlg *BasicMove;

/////////////////////////////////////////////////////////////////////////////
// CDialogDrawDemoDlg dialog
enum DRAWDEMOTYPE
{
	DRAW_DEMO_CIRTIAL = 2,
	DRAW_DEMO_BALL,
	DRAW_DEMO_LEAVES,
	DRAW_DEMO_SIN,
};

CDialogDrawDemoDlg::CDialogDrawDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogDrawDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogDrawDemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CDialogDrawDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogDrawDemoDlg)
	DDX_Control(pDX, IDC_COMBO_DRAWDEMO_TYPE, m_cComboDrawType);
	DDX_Control(pDX, IDC_STC_DRAWDEMO_VT, m_CDrawVT);
	DDX_Control(pDX, IDC_STC_DRAWDEMO_XYPOS, m_CDrawXY);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogDrawDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDialogDrawDemoDlg)
	ON_BN_CLICKED(IDC_BUTTON_DRAWDEMO_START, OnButtonDrawdemoStart)
	ON_BN_CLICKED(IDC_BUTTON_DRAWDEMO_STOP, OnButtonDrawdemoStop)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_DRAWDEMO_CLEAR, OnButtonDrawdemoClear)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogDrawDemoDlg message handlers
// [12/19/2012 Administrator]:ʼؼ
void CDialogDrawDemoDlg::InitComboBox()
{
	m_cComboDrawType.InsertString(0, "Circle");
	m_cComboDrawType.InsertString(1, "Stadium track");
//	m_cComboDrawType.InsertString(2, "Ҷõ");
//	m_cComboDrawType.InsertString(3, "");
	// Ĭʾ򳡹켣
	m_cComboDrawType.SetCurSel(0);

	return;
}

BOOL CDialogDrawDemoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	InitComboBox();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//////////////////////////////////////////////////////////////////////////
//
// [12/20/2012 Administrator]:
void CDialogDrawDemoDlg::StopDraw()
{
		//CDrawCtrl	m_CDrawVT;
	//CDrawCtrl	m_CDrawXY;
	m_CDrawXY.StopDraw();
	m_CDrawVT.StopDraw();

	KillTimer(DRAWDEMOTIMER);
}

//////////////////////////////////////////////////////////////////////////
//
// [12/20/2012 Administrator]:
void CDialogDrawDemoDlg::ClearData()
{
	for (int i=0; i<m_CDrawXY.GetLinesCount(); i++)
	{
		m_CDrawXY.GetLine(i).RemoveAllXYPoints();
	}
	
	for (i=0; i<m_CDrawVT.GetVTLinesCount(); i++)
	{
		m_CDrawVT.GetVTLine(i).RemoveAllVTPoints();
	}

	int nAxis1 = 1;
	int nAxis2 = 2;
	long nPulse1 = 0;
	long nPulse2 = 0;

	CCtrlCardSingletion::Instance()->SetupPos(nAxis1, nPulse1, 0);
	CCtrlCardSingletion::Instance()->SetupPos(nAxis2, nPulse2, 0);
	return;
}
//////////////////////////////////////////////////////////////////////////
//
// [12/19/2012 Administrator]:Բ
void CDialogDrawDemoDlg::DrawCircular()
{
	m_CDrawXY.AddLines(PS_SOLID, RGB(255, 0, 0), 2);
	m_CDrawXY.SetRate(DRAWDEMORATE);
	m_CDrawXY.StartDraw(DRAW_DEMO_CIRTIAL);
	
	m_CDrawVT.AddVTLines(PS_SOLID, RGB(255, 0, 0), 1);
	m_CDrawVT.SetRate(DRAWDEMORATE);
	m_CDrawVT.StartDraw(DRAW_DEMO_CIRTIAL);
	
	SetTimer(DRAWDEMOTIMER, DRAWDEMORATE, NULL);
	
    int err;
	
	UpdateData(TRUE);
	float pos[4]={0,0,0,0};
	float Center[4]={0,4,0,0};
	
	adt8949_set_precount(g_cardID,30);
	adt8949_set_admode(g_cardID,INPA_AXISREG,1);
	adt8949_set_gear(g_cardID,1,1000);
	adt8949_set_gear(g_cardID,2,1000);
	
	adt8949_set_startv(g_cardID,INPA_AXISREG,10);
    adt8949_set_acc(g_cardID,INPA_AXISREG,100);
    adt8949_set_speed(g_cardID,INPA_AXISREG,20);

	err=adt8949_inp_arc2(g_cardID,0,3,pos,Center,1);	
	if (err)
	{
		MessageBox("InpArc2 err");
	}
	
	
	return;

}
//////////////////////////////////////////////////////////////////////////
//
// [12/19/2012 Administrator]:򳡹켣
void CDialogDrawDemoDlg::DrawBallPark()
{
	m_CDrawXY.AddLines(PS_SOLID, RGB(255, 0, 0), 2);
	m_CDrawXY.SetRate(DRAWDEMORATE);
	m_CDrawXY.StartDraw(DRAW_DEMO_BALL);
	
	m_CDrawVT.AddVTLines(PS_SOLID, RGB(255, 0, 0), 1);
	m_CDrawVT.SetRate(DRAWDEMORATE);
	m_CDrawVT.StartDraw(DRAW_DEMO_BALL);
	
	SetTimer(DRAWDEMOTIMER, DRAWDEMORATE, NULL);
	int err;
	UpdateData(TRUE);
	float pos[4]={0,20,0,0};
	float Center[4]={0,10,0,0};
	
	float pos1[4]={0,-20,0,0};
	float Center1[4]={0,-10,0,0}; 
	
	adt8949_set_precount(g_cardID,30);
	adt8949_set_admode(g_cardID,INPA_AXISREG,1);
	adt8949_set_gear(g_cardID,1,1000);
	adt8949_set_gear(g_cardID,2,1000);
		
    adt8949_set_startv(g_cardID,INPA_AXISREG,10);
    adt8949_set_acc(g_cardID,INPA_AXISREG,100);
    adt8949_set_speed(g_cardID,INPA_AXISREG,20);

    adt8949_set_acc_constraint(g_cardID, 1,8000);
    adt8949_set_acc_constraint(g_cardID, 2,8000);
	
	adt8949_inp_move4(g_cardID,0,20,0,0,0);
	
	err=adt8949_inp_arc2(g_cardID,0,3,pos,Center,0);
	if (err)
	{
		MessageBox("InpArc2 err");
	}
	adt8949_inp_move4(g_cardID,0,-20,0,0,0);	
	
	err=adt8949_inp_arc2(g_cardID,0,3,pos1,Center1,0);
	if (err)
	{
		MessageBox("InpArc2 err");
	}
	
	return;
}

//////////////////////////////////////////////////////////////////////////
//
// [12/20/2012 Administrator]:
void CDialogDrawDemoDlg::RoseLeaves(int nStart, int nEnd)
{
	int nCardNo = 0;
	int nAxis1 = 1;
	int nAxis2 = 2;
	
	float nPulseX = 0;
	float nPulesY = 0;
	
	double dfR1 = 0.0;
	double dfR2 = 0.0;
	
	int nLine = 6 * 400;
	double dfStep = PAI/60;
	
	if (nStart > nEnd)
	{
		for (int i=nStart; i>nEnd; i--)
		{
			dfR1 = fabs(nLine * sin(2 * (i-1) * dfStep));
			dfR2 = fabs(nLine * sin(2 * (i) * dfStep));
			
			nPulseX = -(long)(dfR2*cos((i) * dfStep) - dfR1*cos((i-1)*dfStep))*10;
			nPulesY = -(long)(dfR2*sin((i) * dfStep) - dfR1*sin((i-1)*dfStep))*10;
			
			adt8949_inp_move4(g_cardID,0,nAxis1, nAxis2, nPulseX/1000, nPulesY/1000);
			
			
		}
	}
	else
	{
		for (int i=nStart; i<nEnd; i++)
		{
			dfR1 = fabs(nLine * sin(2 * i * dfStep));
			dfR2 = fabs(nLine * sin(2 * (i+1) * dfStep));
			
			nPulseX = (long)(dfR2*cos((i+1) * dfStep) - dfR1*cos(i*dfStep))*10 ;
			nPulesY = (long)(dfR2*sin((i+1) * dfStep) - dfR1*sin(i*dfStep))*10;
			
			adt8949_inp_move4(g_cardID,0,nAxis1, nAxis2, nPulseX/1000, nPulesY/1000); 				
			
		}
	}
	
	return;
}
//////////////////////////////////////////////////////////////////////////
//
// [12/19/2012 Administrator]:Ҷõ
void CDialogDrawDemoDlg::Draw4RoseLeaves()
{
	m_CDrawXY.AddLines(PS_SOLID, RGB(255, 0, 0), 2);
	m_CDrawXY.SetRate(DRAWDEMORATE);
	m_CDrawXY.StartDraw(DRAW_DEMO_LEAVES);
	
	m_CDrawVT.AddVTLines(PS_SOLID, RGB(255, 0, 0), 1);
	m_CDrawVT.SetRate(DRAWDEMORATE);
	m_CDrawVT.StartDraw(DRAW_DEMO_LEAVES);
	
	SetTimer(DRAWDEMOTIMER, DRAWDEMORATE, NULL);

	int nStart = 0;
	int nEnd = 30;
	RoseLeaves(nStart, nEnd);
	nStart = 90;
	nEnd = 120;
	RoseLeaves(nStart, nEnd);
	nStart = 60;
	nEnd = 90;
	RoseLeaves(nStart, nEnd);
	nStart = 30;
	nEnd = 60;
	RoseLeaves(nStart, nEnd);
	
// 	while (TRUE)
// 	{
// 		
// 		DoEvent();
// 		if(m_bIsBreak)
// 		{
// 			break;
// 		}
// 	}
// 	
	return;
}
//////////////////////////////////////////////////////////////////////////
//
// [12/19/2012 Administrator]:
void CDialogDrawDemoDlg::DrawSin()
{
	m_CDrawXY.AddLines(PS_SOLID, RGB(255, 0, 0), 2);
	m_CDrawXY.SetRate(DRAWDEMORATE);
	m_CDrawXY.StartDraw(DRAW_DEMO_SIN);
	
	m_CDrawVT.AddVTLines(PS_SOLID, RGB(255, 0, 0), 1);
	m_CDrawVT.SetRate(DRAWDEMORATE);
	m_CDrawVT.StartDraw(DRAW_DEMO_SIN);
	
	SetTimer(DRAWDEMOTIMER, DRAWDEMORATE, NULL);

	int nCardNo = 0;
	int nAxis1 = 1;
	int nAxis2 = 2;

	long nStartV1 = 25000;
	long nStartV2 = 25000;
	long nSpeed1 = 25000;
	long nSpeed2 = 25000;
	long nAdd1 = 1500;
	long nAdd2 = 1500;

//	CCtrlCardSingletion::Instance()->SetupSpeed(nAxis1, nStartV1, nSpeed1, nAdd1);
//	CCtrlCardSingletion::Instance()->SetupSpeed(nAxis2, nStartV2, nSpeed2, nAdd2);

	double dfTempStep = (2*PAI)/6280;
	double dfSinAng = 0.0;
	
	long curx = 0;
	long cury = 0;
	long oldx = 0;
	long oldy = 0;
	
	adt8949_get_command_pos(g_cardID, 1, &curx);
	adt8949_get_command_pos(g_cardID, 2, &cury);

	oldx = curx;
	oldy = cury;
	float tx = 0;
	float ty = 0;
	
	for (int i=0; i<6280; i++)
	{
		tx = 10;
		ty = (long)(sin(dfSinAng)*10000)-oldy;

		CCtrlCardSingletion::Instance()->InterpMove2(nAxis1, nAxis2, tx, ty);
		int nStatus1 = -1;		

		while (TRUE)
		{
			CCtrlCardSingletion::Instance()->GetStatus(nCardNo, nAxis1, &nStatus1);
			if (0 == nStatus1)
			{
				break;
			}
			DoEvent();
			if(m_bIsBreak)
			{
				break;
			}
		}	

		oldx = (long)(dfSinAng*10000);
		oldy = (long)(sin(dfSinAng)*10000);
		dfSinAng += dfTempStep;
	}

	int nStatus1 = -1;
	while (TRUE)
	{
		CCtrlCardSingletion::Instance()->GetStatus(nCardNo, nAxis1, &nStatus1);
		if (0 == nStatus1)
		{
			m_CDrawVT.StopDraw();
			break;
		}
		DoEvent();
		if(m_bIsBreak)
		{
			break;
		}
	}	

	return;
}
void CDialogDrawDemoDlg::OnButtonDrawdemoStart() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	int nPos = m_cComboDrawType.GetCurSel();

	m_bIsBreak = FALSE;

	switch (nPos)
	{
	case 0:		// Բ
		{
			StopDraw();
			ClearData();
			DrawCircular();
		}
		break;

	case 1:		// 
		{
			StopDraw();
			ClearData();
			DrawBallPark();
		}
		break;

	default:
		;
	}
//	KillTimer(DRAWDEMOTIMER);

	return;
}

void CDialogDrawDemoDlg::OnButtonDrawdemoStop() 
{
	// TODO: Add your control notification handler code here
	m_bIsBreak = TRUE;

	m_CDrawXY.StopDraw();
	m_CDrawVT.StopDraw();
	KillTimer(DRAWDEMOTIMER);
}

void CDialogDrawDemoDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
		CWnd* pStcDrawDemoXYPosTitle = this->GetDlgItem(IDC_STC_DRAWDEMO_XYPOSTITLE);
	CWnd* pStcDrawDemoXYPos = this->GetDlgItem(IDC_STC_DRAWDEMO_XYPOS);
	CWnd* pStcDrawDemoVTTitle = this->GetDlgItem(IDC_STC_DRAWDEMO_VTTITLE);
	CWnd* pStcDrawDemoVT = this->GetDlgItem(IDC_STC_DRAWDEMO_VT);
	CWnd* pStcDrawDemoType = this->GetDlgItem(IDC_STC_DRAWDEMO_TYPE);
	CWnd* pExtendCombDrawDemoType = this->GetDlgItem(IDC_COMBO_DRAWDEMO_TYPE);

	CWnd* pBtnDrawDemoStart = this->GetDlgItem(IDC_BUTTON_DRAWDEMO_START);
	CWnd* pBtnDrawDemoStop = this->GetDlgItem(IDC_BUTTON_DRAWDEMO_STOP);
	CWnd* pBtnDrawDemoClear = this->GetDlgItem(IDC_BUTTON_DRAWDEMO_CLEAR);

	CRect rc;
	int nTemp = 5;
	BOOL bIsXYPos = TRUE;
	BOOL bIsVT = TRUE;

	if (pStcDrawDemoXYPosTitle->GetSafeHwnd()!=NULL && pStcDrawDemoVTTitle->GetSafeHwnd()!=NULL && pStcDrawDemoType->GetSafeHwnd()!=NULL &&
		pStcDrawDemoXYPos->GetSafeHwnd()!=NULL && pStcDrawDemoVT->GetSafeHwnd() != NULL
		)
	{
		pStcDrawDemoXYPosTitle->GetWindowRect(&rc);
		ScreenToClient(&rc);
		pStcDrawDemoXYPosTitle->MoveWindow(0, 0, cx*2/5-nTemp, cy);

		pStcDrawDemoXYPos->MoveWindow(nTemp, 3*nTemp, cx*2/5-3*nTemp, cy-4*nTemp);
		m_CDrawXY.InitCtrlRectXY(bIsXYPos);

		pStcDrawDemoVTTitle->MoveWindow(cx*2/5, 0, cx*2/5-nTemp, cy);
		pStcDrawDemoVT->MoveWindow(cx*2/5+nTemp, 3*nTemp, cx*2/5-3*nTemp, cy-4*nTemp);
		m_CDrawVT.InitCtrlRectVT(bIsVT);

		pStcDrawDemoType->MoveWindow(cx*4/5, 0, cx/5, cy);

		pExtendCombDrawDemoType->GetWindowRect(&rc);
		ScreenToClient(&rc);
		pExtendCombDrawDemoType->MoveWindow(cx*4/5+2*nTemp, 4*nTemp, cx/5-4*nTemp, rc.Height());

		pBtnDrawDemoStart->GetWindowRect(&rc);
		ScreenToClient(&rc);
		pBtnDrawDemoStart->MoveWindow(cx*4/5+2*nTemp, rc.Height() + 5*nTemp, rc.Width(), rc.Height());

		pBtnDrawDemoStop->MoveWindow(cx*4/5+2*nTemp, 2*rc.Height() + 6*nTemp, rc.Width(), rc.Height());
		pBtnDrawDemoClear->MoveWindow(cx*4/5+2*nTemp, 3*rc.Height() + 7*nTemp, rc.Width(), rc.Height());
	}/**/
}

void CDialogDrawDemoDlg::OnButtonDrawdemoClear() 
{
	// TODO: Add your control notification handler code here
	m_CDrawXY.StopDraw();
	m_CDrawVT.StopDraw();
	KillTimer(DRAWDEMOTIMER);
	for (int i=0; i<m_CDrawXY.GetLinesCount(); i++)
	{
		m_CDrawXY.GetLine(i).RemoveAllXYPoints();
	}

	for (i=0; i<m_CDrawVT.GetVTLinesCount(); i++)
	{
		m_CDrawVT.GetVTLine(i).RemoveAllVTPoints();
	}
}

void CDialogDrawDemoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	long nLogPosX = 0;
	long nActPosX = 0;
	long nLogPosY = 0;
	long nActPosY = 0;
	float nSpeedX = 0.0;
	float nSpeedY = 0.0;
	int sta = -1;
	adt8949_get_inp_status(g_cardID,&sta);
	if(!sta)
	{
		Sleep(50);
		m_CDrawXY.StopDraw();
		m_CDrawVT.StopDraw();
		KillTimer(DRAWDEMOTIMER);
	}

	if (DRAWDEMOTIMER == nIDEvent)
	{
		for (int i=1; i<4+1; i++)
		{
			if (1 == i)
			{
				CCtrlCardSingletion::Instance()->INP_GetCurrentInfo(i, nLogPosX, nActPosX, nSpeedX);
		
			}
			else if (2 == i)
			{
				CCtrlCardSingletion::Instance()->INP_GetCurrentInfo(i, nLogPosY, nActPosY, nSpeedY);
			}
		}
		m_CDrawXY.GetLine(0).AddPointXY(nLogPosX, nLogPosY);
		m_CDrawVT.GetVTLine(0).AddPointVX(nSpeedX*2000);
	}

	CDialog::OnTimer(nIDEvent);
}
